
/*****************************************/
/* Format the 1991, 1998, 2001, 2007 and 2008 waves */
/*****************************************/

/********************************************************/
/* Note that there is also data for 1989 and for 2002.  */
/* The 1989 data does not ask about overall happiness,  */
/* however, and the 2002 data has completely different  */
/* 7-point scale, so I throw out both waves.   			*/
/* The 2002 question is also scheduled for the 			*/
/* 2011 Health wave and the 2012 Family wave			*/
/********************************************************/

* Load and format the 1991 data 
use "$directory/issp/1991/ZA2150_F1", clear
gen hap =5-v4 
replace hap =. if hap >5 | hap <0
label define hap 1 "Not at all happy" 2 "Not very happy" 3 "Fairly happy" 4 "Very happy"
label values hap hap
    
        /************************************/
        /*  Question text:                  */
        /*  If you were to consider your    */
        /*  life in general these days, how */
        /*  happy or unhappy would you say  */
        /*  you are, on the whole?          */
        /*  (Please tick one box only)      */
        /*                                  */
        /*  in Russia (RUS):                */
        /*  Q.1_RUS                         */
        /*  Speaking about your life in     */
        /*  general, could you say, that    */
        /*  you are happy or unhappy now?   */
        /*                                  */
        /*  1 Very happy                    */
        /*  2 Fairly happy                  */
        /*  3 Not very happy                */
        /*  4 Not at all happy              */
        /*  8 Can't choose, don't know      */
        /*  9 NA                            */
        /************************************/
    
gen wt=v131
replace wt=1 if wt==.
gen year=1991
gen sex=v77
gen cty = ""
replace cty = "FRG" if v3 == 1
replace cty = "GDR" if v3 == 2
replace cty = "GBR" if v3 == 3
replace cty = "NIR" if v3 == 4
replace cty = "USA" if v3 == 5
replace cty = "HUN" if v3 == 6
replace cty = "NLD" if v3 == 7
replace cty = "ITA" if v3 == 8
replace cty = "IRL" if v3 == 9
replace cty = "NOR" if v3 == 10
replace cty = "AUT" if v3 == 11
replace cty = "SVN" if v3 == 12
replace cty = "POL" if v3 == 13
replace cty = "ISR" if v3 == 14
replace cty = "PHL" if v3 == 15
replace cty = "NZL" if v3 == 16
replace cty = "RUS" if v3 == 17
replace cty = "AUS" if v3 == 18
        
gen nonrepresentative=0
gen cty_id=v3
keep hap wt year nonrep sex  cty
replace wt=1 if cty == "AUS"
        
save "$directory/issp/ISSP_1991", replace
    
* Format 1998
use "$directory/issp/1998/ZA3190_F1", clear
gen hap = 5-v4
replace hap =. if hap >5 | hap <=0
label values hap hap        
        
        /************************************************/
        /* Question text (Q.1)                          */
        /* If you were to consider your life in general */
        /* these days, how happy or unhappy would you   */
        /* say you are, on the whole?                   */
        /* (Please tick one box only)                   */
        /*  1 Very happy                                */
        /*  2 Fairly happy                              */
        /*  3 Not very happy                            */
        /*  4 Not at all happy                          */
        /*  8 Can't choose, don't know                  */
        /*  9 No answer                                 */
        /************************************************/
        
gen wt=v316
replace wt=1 if wt==.
gen year=1998
gen sex=v200 if v200==1 | v200==2
        
gen cty = ""
replace cty = "AUS" if v3 == 1
replace cty = "FRG" if v3 == 2
replace cty = "GDR" if v3 == 3
replace cty = "GBR" if v3 == 4
replace cty = "NIR" if v3 == 5
replace cty = "USA" if v3 == 6
replace cty = "AUS" if v3 == 7
replace cty = "HUN" if v3 == 8
replace cty = "ITA" if v3 == 9
replace cty = "IRL" if v3 == 10
replace cty = "NLD" if v3 == 11
replace cty = "NOR" if v3 == 12
replace cty = "SWE" if v3 == 13
replace cty = "CZE" if v3 == 14
replace cty = "SVN" if v3 == 15
replace cty = "POL" if v3 == 16
replace cty = "BGR" if v3 == 17
replace cty = "RUS" if v3 == 18
replace cty = "NZL" if v3 == 19
replace cty = "CAN" if v3 == 20
replace cty = "PHL" if v3 == 21
replace cty = "ISR" if v3 == 22
replace cty = "JPN" if v3 == 24
replace cty = "ESP" if v3 == 25
replace cty = "LVA" if v3 == 26
replace cty = "SVK" if v3 == 27
replace cty = "FRA" if v3 == 28
replace cty = "CYP" if v3 == 29
replace cty = "PRT" if v3 == 30
replace cty = "CHL" if v3 == 31
replace cty = "DNK" if v3 == 32
replace cty = "CHE" if v3 == 33
gen cty_id=v3
rename v3 cty1998
gen nonrepresentative=0
keep hap wt year nonrep sex  cty_id cty1998 cty
save "$directory/issp/ISSP_1998", replace
    
    /***************/
    /* Format 2001 */
    /***************/
        use "$directory/issp/2001/ZA3680_F1", clear
        gen hap=5-v57
        replace hap =. if hap >5 | hap <0
		label values hap hap
        /************************************************/
        /* Question text (Q.33)                          */
        /* If you were to consider your life in general */
        /* these days, how happy or unhappy would you   */
        /* say you are, on the whole?                   */
        /* (Please tick one box only)                   */
        /*  1 Very happy                                */
        /*  2 Fairly happy                              */
        /*  3 Not very happy                            */
        /*  4 Not at all happy                          */
        /*  8 Can't choose, don't know                  */
        /*  9 No answer                                 */
        /************************************************/
        gen wt=weight
        replace wt=1 if wt==.
        gen year=2001
        replace sex=. if sex~=1 & sex~=2
        gen cty = ""
        replace cty = "AUS" if v3 == 1
        replace cty = "FRG" if v3 == 2
        replace cty = "GDR" if v3 == 3
        replace cty = "GBR" if v3 == 4
        replace cty = "NIR" if v3 == 5
        replace cty = "USA" if v3 == 6
        replace cty = "AUT" if v3 == 7
        replace cty = "HUN" if v3 == 8
        replace cty = "ITA" if v3 == 9
        replace cty = "NOR" if v3 == 12
        replace cty = "CZE" if v3 == 14
        replace cty = "SVN" if v3 == 15
        replace cty = "POL" if v3 == 16
        replace cty = "RUS" if v3 == 18
        replace cty = "NZL" if v3 == 19
        replace cty = "CAN" if v3 == 20
        replace cty = "PHL" if v3 == 21
        replace cty = "ISR" if v3 == 22
        replace cty = "ISR" if v3 == 23
        replace cty = "JPN" if v3 == 24
        replace cty = "ESP" if v3 == 25
        replace cty = "LVA" if v3 == 26
        replace cty = "FRA" if v3 == 28
        replace cty = "CYP" if v3 == 29
        replace cty = "CHL" if v3 == 31
        replace cty = "DNK" if v3 == 32
        replace cty = "CHE" if v3 == 33
        replace cty = "BRA" if v3 == 35
        replace cty = "ZAF" if v3 == 36
        replace cty = "FIN" if v3 == 37
        gen cty_id=v3
        rename v3 cty2001 
		gen nonrepresentative=0
        keep hap wt year nonrep sex  cty_id cty2001 cty
        save "$directory/issp/ISSP_2001", replace

    /***************/
    /* Format 2007 */
    /***************/
        use "$directory/issp/2007/ZA4850_F1", clear
        gen hap=5-V64
        replace hap =. if hap >5 | hap <0
		label values hap hap
        /************************************************/
        /* Question text (Q.16)                          */
        /* If you were to consider your life in general */
        /* these days, how happy or unhappy would you   */
        /* say you are, on the whole?                   */
        /* (Please tick one box only)                   */
        /*  1 Very happy                                */
        /*  2 Fairly happy                              */
        /*  3 Not very happy                            */
        /*  4 Not at all happy                          */
        /*  8 Can't choose, don't know                  */
        /*  9 No answer                                 */
        /* note that there are .a and .b codings here   */
        /************************************************/
        gen wt=WEIGHT
        replace wt=1 if wt==.
        gen year=2007
        replace SEX=. if SEX~=1 & SEX ~=2
        gen cty = ""
        replace cty = "ARG" if V5 == 32
        replace cty = "AUS" if V5 == 36
        replace cty = "AUT" if V5 == 40
        replace cty = "BEL" if V5 == 56
        replace cty = "BGR" if V5 == 100
        replace cty = "CHL" if V5 == 152
        replace cty = "TWN" if V5 == 158
        replace cty = "HRV" if V5 == 191
        replace cty = "CYP" if V5 == 196
        replace cty = "CZE" if V5 == 203
        replace cty = "DOM" if V5 == 214
        replace cty = "FIN" if V5 == 246
        replace cty = "FRA" if V5 == 250
        replace cty = "DEU" if V5 == 276
        replace cty = "HUN" if V5 == 348
        replace cty = "IRL" if V5 == 372
        replace cty = "ISR" if V5 == 376
        replace cty = "JPN" if V5 == 392
        replace cty = "KOR" if V5 == 410
        replace cty = "LVA" if V5 == 428
        replace cty = "MEX" if V5 == 484
        replace cty = "NZL" if V5 == 554
        replace cty = "NOR" if V5 == 578
        replace cty = "PHL" if V5 == 608
        replace cty = "POL" if V5 == 616
        replace cty = "RUS" if V5 == 643
        replace cty = "SVK" if V5 == 703
        replace cty = "SVN" if V5 == 705
        replace cty = "ZAF" if V5 == 710
        replace cty = "SWE" if V5 == 752
        replace cty = "CHE" if V5 == 756
        replace cty = "GBR" if V5 == 826
        replace cty = "USA" if V5 == 840
        replace cty = "URY" if V5 == 858
        
        replace cty = "FRG" if V4 == 276.1 /* replace east/west German */
        replace cty = "GDR" if V4 == 276.2 
        
        gen nonrepresentative = (cty == "BEL") /*Survey just of the Flemish region plus Brussels; omits Walloon region*/
        
        gen cty_id=V5
        rename V5 cty2007 
        rename V4 place2007
        keep hap wt year nonrep SEX  cty
        save "$directory/issp/ISSP_2007", replace
        
    /***************/
    /* Format 2008 */
    /***************/
        use "$directory/issp/2008/ZA4950_F1", clear
        gen hap=5-V6
        replace hap =. if hap >5 | hap <0
		label values hap hap
        /************************************************/
        /* Question text (Q.33)                          */
        /* If you were to consider your life in general */
        /* these days, how happy or unhappy would you   */
        /* say you are, on the whole?                   */
        /* (Please tick one box only)                   */
        /*  1 Very happy                                */
        /*  2 Fairly happy                              */
        /*  3 Not very happy                            */
        /*  4 Not at all happy                          */
        /*  8 Can't choose, don't know                  */
        /*  9 No answer                                 */
        /* note that there are .a and .b codings here   */
        /************************************************/
        gen wt=WEIGHT
        replace wt=1 if wt==.
        gen year=2008
        replace SEX = . if SEX ~=1 & SEX ~=2
        gen cty = ""
        replace cty = "AUS" if V5 == 36
        replace cty = "AUT" if V5 == 40
        replace cty = "BEL" if V5 == 56
        replace cty = "CHL" if V5 == 152
        replace cty = "TWN" if V5 == 158
        replace cty = "HRV" if V5 == 191
        replace cty = "CYP" if V5 == 196
        replace cty = "CZE" if V5 == 203
        replace cty = "DNK" if V5 == 208
        replace cty = "DOM" if V5 == 214
        replace cty = "FIN" if V5 == 246
        replace cty = "FRA" if V5 == 250
        replace cty = "DEU" if V5 == 276
        replace cty = "HUN" if V5 == 348
        replace cty = "IRL" if V5 == 372
        replace cty = "ISR" if V5 == 376
        replace cty = "ITA" if V5 == 380
        replace cty = "JPN" if V5 == 392
        replace cty = "KOR" if V5 == 410
        replace cty = "LVA" if V5 == 428
        replace cty = "MEX" if V5 == 484
        replace cty = "NLD" if V5 == 528
        replace cty = "NZL" if V5 == 554
        replace cty = "NOR" if V5 == 578
        replace cty = "PHL" if V5 == 608
        replace cty = "POL" if V5 == 616
        replace cty = "PRT" if V5 == 620
        replace cty = "RUS" if V5 == 643
        replace cty = "SVK" if V5 == 703
        replace cty = "SVN" if V5 == 705
        replace cty = "ZAF" if V5 == 710
        replace cty = "ESP" if V5 == 724
        replace cty = "SWE" if V5 == 752
        replace cty = "CHE" if V5 == 756
        replace cty = "TUR" if V5 == 792
        replace cty = "UKR" if V5 == 804
        replace cty = "GBR" if V5 == 826
        replace cty = "USA" if V5 == 840
        replace cty = "URY" if V5 == 858
        replace cty = "VEN" if V5 == 862
        replace cty = "FRG" if V4 == 276.1 /* replace east/west German */
        replace cty = "GDR" if V4 == 276.2 
        gen nonrepresentative = (cty == "BEL") /*Survey just of the Flemish region plus Brussels; omits Walloon region*/
 
        gen cty_id=V5
        rename V5 cty2008 
        rename V4 place2008
        keep hap wt year nonrep SEX cty_id cty2008 place2008 cty
        save "$directory/issp/ISSP_2008", replace
        
        
/************************************/
/* Make into single macro data set  */
/************************************/
    
    /**********************/
    /* append older waves */
    /**********************/
	clear
	foreach year in 1991 1998 2001 2007 2008 {
		append using "$directory/issp/ISSP_`year'"
	}
	save "$directory\issp\ISSP_micro", replace
    
    /****************************/
    /* Standardize happiness    */
    /****************************/
        sum hap [aw=wt]
        gen hap_z_all = (hap - r(mean))/r(sd)
        local mean = r(mean)
        gen hap_mean_all = `mean'
        gen hap_sd_all = r(sd)
        
        xi: reg hap i.cty i.year [aw=wt]
        predict hap_res if !missing(hap), residual
        sum hap_res [aw=wt]
		local sd=r(sd)
        gen hap_z = (hap-`mean')/r(sd)
		char hap_z[mean] "`mean'"
		char hap_z[sd] "`sd'"

        
        

        
    /************************************************************************************************/
    /* Fixing Northern Ireland                                                                      */
    /* For all data sets with NIR, I think the best thing to do                                     */
    /* is take the weights for NIR and for GBR, and rescale them so that the relative weight        */
    /* of each is proportional to its share of the population, and so that the sum of the weights   */
    /* is equal to GBR's initial sum of weights.                                                    */
    /************************************************************************************************/
    
    /********************************************************************/
    /* note that I treat the population of the UK and NIR as a local    */
    /* UK population in 2008: 61398.2 (thousands)                       */
    /* UK population in 2009: 61792.0 (thousands)                       */
    /* Source: www.statistics.gov.uk                                    */
    /*                                                                  */
    /* UK population data otherwise come from pwt                       */
    /* NIR population data come from nisra.gov.uk                       */
    /********************************************************************/
    
    
    /****************************/
    /* Load the population data */
    /****************************/
    
        replace year = int(year)
        capture sum pop
		merge m:1 cty year using "$directory/gdp/Complete_GDP", keepusing(pop) keep(master match match_update)

        tab _m
        drop if _m == 2
        drop _merge
        replace pop = 61398.2 if year == 2008 & cty == "GBR"
        replace pop = 61792.0 if year == 2009 & cty == "GBR"
		merge m:1 cty year using "$directory/gdp/Raw/nir", keepusing(pop) update keep(master match match_update)
        tab _m
        drop if _m==2
        drop _merge
        
        gen nir = (cty=="NIR")
        levelsof year if cty == "NIR", local(years)
        foreach year of local years{
            /* get populations for the year */
            sum pop if cty == "NIR" & year==`year'
            local popNIR = r(mean)
            sum pop if cty == "GBR" & year == `year'
            local popUK = r(mean)
            
            /* get total weight for GBR */
            sum wt if cty == "GBR" & year == `year'
            local oldSum = r(N)*r(mean)
            
            /* Step 1: get ratios right, adjusting for differences in total weights */
            sum wt if cty == "NIR" & year == `year'
            replace wt = wt *(`popNIR'/`popUK')/(r(mean)*r(N)) if cty == "NIR" & year == `year'
            sum wt if cty == "GBR" & year == `year'
            replace wt = wt *(1-`popNIR'/`popUK')/(r(mean)*r(N)) if cty == "GBR" & year == `year'
                
            /* Step 2: fold NIR into GBR */
            replace cty = "GBR" if cty == "NIR" & year == `year'
            
            /* Step 3: get the the total weight right */
            sum wt if cty == "GBR" & year == `year'
            replace wt = wt*`oldSum'/(r(N)*r(mean)) if cty == "GBR" & year == `year'
            
        }
        drop pop /* note that the pop variable isn't even correct anymore */

 
/* Merge in the macro indicators    */
merge m:1 cty year using "$directory/gdp/Complete_GDP", keep(master match)
assert _merge==3
drop _merge
save "$directory/ISSP/ISSP_micro", replace
for X in num 1991 1998 2001 2007 2008: rm "$directory/ISSP/ISSP_X.dta"
gen wave=year
        
collapse (mean) hap* nonrep gdp lgdp [aw=wt], by(cty wave)
char hap_z[mean] "`mean'"
char hap_z[sd] "`sd'"
compress
save "$directory/ISSP/ISSP_Macro", replace
rm "$directory/ISSP/ISSP_Micro.dta"
   
    
    
    
    


